procedure $see_coefficients
argument local string scalar runno
argument local namelist freqs
argument local string scalar db_path = ""
block

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   if not exists(lout'vars)
      if local'loutopened
         close lout
      end if
      return
   end if

   device graphics postp
   page frame off
   page margins horizontal 0.04, vertical 0.02

   legend size xsmall, fill horizontal, color black, font F6
   legend division row 1, column auto
   legend content symbol on, line off
   legend area move at, x 0, y 1
   legend lines justify left
   tick bottom numeric linear (16 to 80 step 8)
   tick label size xsmall, font F10
   label bottom text "Age", size xsmall, font f6

   map color postscript C7 "B9B9B9", C8 "D9D9D9"

   -- Z=2.000 = 95.5% two-sided bounds
   -- Z=1.960 = 95.0% two-sided bounds
   -- Z=1.645 = 90.0% two-sided bounds
   -- Z=1.000 = 68.3% two-sided bounds
   -local'z1 = 2; -local'z1lab = "2SE Bands"
   -local'z2 = 1; -local'z2lab = "1SE Bands"
   scatter #1 between paint, scolor C8, color C8, draw line, style solid
   scatter #2 between paint, scolor C8, color C8, draw line, style solid, symbol ssquare, points first
   scatter #3 between paint, scolor C7, color C7, draw line, style solid
   scatter #4 between paint, scolor C7, color C7, draw line, style solid, symbol ssquare, points first
   scatter #5 between paint, scolor C8, color C8, draw line, style solid
   scatter #6 between paint, scolor C8, color C8, draw line, style solid
   scatter #7 color black, draw line, style solid
   scatter #8 color black, draw line, style solid


   page divi rows 3, columns 1

   loop for sfreq in freqs
      -local'strfreq = (if name(sfreq) eq "M" then "Monthly" else "Quarterly")

      open <ac over; kind graphic> file("run"+local'runno+"coeff_"+name(sfreq)+".ps") as coeff.ps
      channel graphics coeff.ps
      channel reports coeff.ps
      -local'varlist = nl(lout'vars)

      loop for var in varlist
         -local'ccell = 0
         -local'varnum = nameloc(varlist,var)
         -local'sexlabs = list("Men","Women")
         loop for sex in {m,f}
            if ((lout'varsex[local'varnum] ne 0) and (nameloc({f,m},sex) ne lout'varsex[local'varnum]))
               next
            end if
            set local'ccell = local'ccell + 1
            if local'ccell GT 3; refresh; set local'ccell = 1; end if;
            if local'ccell eq 1; legend appear on; else; legend appear off; end if

            cell(local'ccell,1)
            graph 
               axis label #1 left size small, font f6, text lout'vardesc[local'varnum]+" ("+sexlabs[nameloc({m,f},sex)]+")"
               data z1*lout'var&e&sex&sfreq+lout'var&c&sex&sfreq <scatter legend off>, &&
                    z2*lout'var&e&sex&sfreq+lout'var&c&sex&sfreq <scatter name local'z1lab>, &&
                    z2*lout'var&e&sex&sfreq+lout'var&c&sex&sfreq <scatter legend off>, &&
                   -z2*lout'var&e&sex&sfreq+lout'var&c&sex&sfreq <scatter name local'z2lab>, &&
                   -z2*lout'var&e&sex&sfreq+lout'var&c&sex&sfreq <scatter legend off>, &&
                   -z1*lout'var&e&sex&sfreq+lout'var&c&sex&sfreq <scatter legend off>, &&
                      lout'var&c&sex&sfreq <scatter legend off> &&
                   vs lout'agesm
               draw line (@bottom.axis.min,0) to (@bottom.axis.max,0)
            end graph

            if (lout'varlagged[local'varnum] eq 1)
               loop for l = 1 to lastvalue(lout'v&id(string(local'varnum))&_lags)
                  -local'lag = string(lout'v&id(string(local'varnum))&_lags[l])
                  set local'ccell = local'ccell + 1
                  if local'ccell GT 3; refresh; set local'ccell = 1; end if;
                  if local'ccell eq 1; legend appear on; else; legend appear off; end if

                  cell (local'ccell,1)
                  graph 
                     axis label #1 left size small, font f6, text lout'vardesc[local'varnum]+" - "+local'lag+" Month Lag ("+sexlabs[nameloc({m,f},sex)]+")"
                     data z1*lout'var&e&id(local'lag)&sex&sfreq+lout'var&c&id(local'lag)&sex&sfreq <scatter legend off>, &&
                          z2*lout'var&e&id(local'lag)&sex&sfreq+lout'var&c&id(local'lag)&sex&sfreq <scatter name local'z1lab>, &&
                          z2*lout'var&e&id(local'lag)&sex&sfreq+lout'var&c&id(local'lag)&sex&sfreq <scatter legend off>, &&
                         -z2*lout'var&e&id(local'lag)&sex&sfreq+lout'var&c&id(local'lag)&sex&sfreq <scatter name local'z2lab>, &&
                         -z2*lout'var&e&id(local'lag)&sex&sfreq+lout'var&c&id(local'lag)&sex&sfreq <scatter legend off>, &&
                         -z1*lout'var&e&id(local'lag)&sex&sfreq+lout'var&c&id(local'lag)&sex&sfreq <scatter legend off>, &&
                            lout'var&c&id(local'lag)&sex&sfreq <scatter legend off> &&
                         vs lout'agesm
                     draw line (@bottom.axis.min,0) to (@bottom.axis.max,0)
                  end graph
               end loop -- end lag num loop
            end if
         end loop -- end gender loop
         refresh
      end loop

      close coeff.ps
      execute "!(ps2pdf run"+local'runno+"coeff_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"coeff_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"coeff_"+name(sfreq)+".ps)&"

   end loop

   if local'loutopened
      close lout
   end if

end block
end procedure
